package gov.va.vinci.dart.dms.biz;

import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Location;
import gov.va.vinci.dart.biz.Participant;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.biz.RequestAdminLocationDocument;
import gov.va.vinci.dart.biz.RequestAdminParticipantDocument;
import gov.va.vinci.dart.biz.RequestLocationDocument;
import gov.va.vinci.dart.biz.RequestParticipantDocument;
import gov.va.vinci.dart.biz.ResearchStudy;
import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestDocument extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		ResearchStudy.findById(1);

		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest req = reqList.get(0);
		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
	
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);

		DocumentTemplate dt = dtList.get(0);
		Assert.assertNotNull(dt);

		Document doc = Document.create(req, dt, "DNS");
		Assert.assertNotNull(doc);
		Assert.assertTrue(doc.getId() > 0);
		Assert.assertEquals(doc.getHead(), doc.getId());  // document is created with head pointing to itself
		
		// does that new document have the 'CURRENT' label?
		Assert.assertNotNull(doc.getLabels());
		Assert.assertTrue(doc.getLabels().size() > 0);
		
		boolean foundit = false;
		for (Label lbl : doc.getLabels()) {
			if ("CURRENT".equals(lbl.getValue()) == true) {
				foundit = true;
				break;
			}
		}
		
		Assert.assertTrue(foundit);
		
		Document doc2 = Document.findById(doc.getId());
		Assert.assertNotNull(doc2);
		Assert.assertTrue(doc2.getId() > 0);
		Assert.assertEquals(doc2, doc);

		doc.delete();

		Document doc3 = Document.findById(doc.getId());
		Assert.assertNull(doc3);
	}

	@Test
	public void testTwo() throws Exception {
		ResearchStudy.findById(1);
		
		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest req = reqList.get(0);
		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
	
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);

		DocumentTemplate dt = dtList.get(0);
		Assert.assertNotNull(dt);

		Document doc = Document.create(req, dt, "DNS");
		Assert.assertNotNull(doc);
		Assert.assertTrue(doc.getId() > 0);
		Assert.assertEquals(doc.getVersionNumber(), 1);

		Document dTest = Document.findCurrentVersion(doc.getId());
		Assert.assertNotNull(dTest);
		Assert.assertEquals(dTest, doc);

		dTest = Document.findMostRecentVersion(doc.getId());
		Assert.assertNotNull(dTest);
		Assert.assertEquals(dTest, doc);

		// sleep for 2 seconds so the timestamps on the documents will be distinct
		Thread.sleep(2000);
		
		Document doc2 = doc.createNewVersion("DNS");
		Assert.assertNotNull(doc2);
		Assert.assertTrue(doc2.getId() > 0);
		Assert.assertEquals(doc2.getHead(), doc.getId());
		Assert.assertEquals(doc2.getVersionNumber(), 2);

		// does that new document have the 'CURRENT' label?
		Assert.assertNotNull(doc2.getLabels());
		Assert.assertTrue(doc2.getLabels().size() > 0);
		
		boolean foundit = false;
		for (Label lbl : doc2.getLabels()) {
			if ("CURRENT".equals(lbl.getValue()) == true) {
				foundit = true;
				break;
			}
		}
		
		Assert.assertTrue(foundit);

		// does the original document NOT have the 'CURRENT' label?
		Assert.assertNotNull(doc.getLabels());

		foundit = false;
		for (Label lbl : doc.getLabels()) {
			if ("CURRENT".equals(lbl.getValue()) == true) {
				foundit = true;
				break;
			}
		}
		
		Assert.assertFalse(foundit);

		
		dTest = Document.findCurrentVersion(doc.getId());
		Assert.assertNotNull(dTest);
		Assert.assertEquals(dTest, doc2);

		dTest = Document.findMostRecentVersion(doc.getId());
		Assert.assertNotNull(dTest);
		Assert.assertEquals(dTest, doc2);

		// sleep for 2 seconds so the timestamps on the documents will be distinct
		Thread.sleep(2000);

		Document doc3 = doc2.createNewVersion("DNS");
		Assert.assertNotNull(doc3);
		Assert.assertTrue(doc3.getId() > 0);
		Assert.assertEquals(doc3.getHead(), doc.getId());
		Assert.assertEquals(doc3.getVersionNumber(), 3);

		dTest = Document.findCurrentVersion(doc.getId());
		Assert.assertNotNull(dTest);
		Assert.assertEquals(dTest, doc3);

		dTest = Document.findMostRecentVersion(doc.getId());
		Assert.assertNotNull(dTest);
		Assert.assertEquals(dTest, doc3);

		List<Document> dList = Document.listVersionsById(doc.getId());
		Assert.assertNotNull(dList);
		Assert.assertTrue(dList.size() > 0);
		Assert.assertTrue(dList.contains(doc));
		Assert.assertTrue(dList.contains(doc2));
		Assert.assertTrue(dList.contains(doc3));
		
		// it doesn't matter which doc in the version chain you pass, this method will always return the current.
		dTest = Document.findCurrentVersion(doc.getId());
		Assert.assertNotNull(dTest);
		Assert.assertEquals(dTest, doc3);

		dTest = Document.findCurrentVersion(doc2.getId());
		Assert.assertNotNull(dTest);
		Assert.assertEquals(dTest, doc3);

		dTest = Document.findCurrentVersion(doc3.getId());
		Assert.assertNotNull(dTest);
		Assert.assertEquals(dTest, doc3);

	}

	@Test
	public void testThree() throws Exception {
		ResearchStudy.findById(1);

		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest req = reqList.get(0);
		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
	
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);

		DocumentTemplate dt = dtList.get(0);
		Assert.assertNotNull(dt);

		Document doc = Document.create(req, dt, "DNS");
		Assert.assertNotNull(doc);
		Assert.assertTrue(doc.getId() > 0);
		Assert.assertEquals(doc.getVersionNumber(), 1);

		Content content = Content.create("pdf", 1);
		Assert.assertNotNull(content);
		Assert.assertTrue(content.getId() > 0);
		
		doc.setContent(content);
		
		List<Document> dList = Document.listByContentId(content.getId());
		Assert.assertNotNull(dList);
		Assert.assertTrue(dList.size() > 0);
		Assert.assertTrue(dList.contains(doc));
	}

	@Test
	public void testFour() throws Exception {
		ResearchStudy.findById(1);

		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest req = reqList.get(0);
		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
	
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);

		DocumentTemplate dt = dtList.get(0);
		Assert.assertNotNull(dt);

		Person pers = Person.findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);
		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);
		
		Group grp = pers.getGroups().iterator().next();
		Assert.assertNotNull(grp);
		Assert.assertTrue(grp.getId() > 0);
		
		Location loc = pers.getLocation();
		Assert.assertNotNull(loc);
		Assert.assertTrue(loc.getId() > 0);
		
		Document doc = Document.create(req, dt, "DNS");
		Assert.assertNotNull(doc);
		Assert.assertTrue(doc.getId() > 0);
		Assert.assertEquals(doc.getVersionNumber(), 1);

		// now the request needs an admin location document
		RequestAdminLocationDocument rald = RequestAdminLocationDocument.create(req, loc, doc, grp); 
		Assert.assertNotNull(rald);
		Assert.assertTrue(rald.getId() > 0);
		
		String locName = Document.findLocationByDocId(doc.getId());
		Assert.assertNotNull(locName);
		Assert.assertEquals(locName, loc.getName());
	}

	@Test
	public void testFive() throws Exception {
		ResearchStudy.findById(1);

		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest req = reqList.get(0);
		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
	
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);

		DocumentTemplate dt = dtList.get(0);
		Assert.assertNotNull(dt);

		Person pers = Person.findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);
		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);
		
		Group grp = pers.getGroups().iterator().next();
		Assert.assertNotNull(grp);
		Assert.assertTrue(grp.getId() > 0);
		
		Location loc = pers.getLocation();
		Assert.assertNotNull(loc);
		Assert.assertTrue(loc.getId() > 0);
		
		Document doc = Document.create(req, dt, "DNS");
		Assert.assertNotNull(doc);
		Assert.assertTrue(doc.getId() > 0);
		Assert.assertEquals(doc.getVersionNumber(), 1);

		Participant part = Participant.create(pers, req, loc, true, true, true);
		Assert.assertNotNull(part);
		Assert.assertTrue(part.getId() > 0);
		
		// now the request needs an admin participant document
		RequestAdminParticipantDocument rapd = RequestAdminParticipantDocument.create(req, part, doc, grp); 
		Assert.assertNotNull(rapd);
		Assert.assertTrue(rapd.getId() > 0);
		
		String locName = Document.findLocationByDocId(doc.getId());
		Assert.assertNotNull(locName);
		Assert.assertEquals(locName, loc.getName());
	}

	@Test
	public void testSix() throws Exception {
		ResearchStudy.findById(1);

		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest req = reqList.get(0);
		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
	
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);

		DocumentTemplate dt = dtList.get(0);
		Assert.assertNotNull(dt);

		Person pers = Person.findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);
		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);
		
		Group grp = pers.getGroups().iterator().next();
		Assert.assertNotNull(grp);
		Assert.assertTrue(grp.getId() > 0);
		
		Location loc = pers.getLocation();
		Assert.assertNotNull(loc);
		Assert.assertTrue(loc.getId() > 0);
		
		Document doc = Document.create(req, dt, "DNS");
		Assert.assertNotNull(doc);
		Assert.assertTrue(doc.getId() > 0);
		Assert.assertEquals(doc.getVersionNumber(), 1);

		// now the request needs an admin location document
		RequestLocationDocument rald = RequestLocationDocument.create(req, loc, doc); 
		Assert.assertNotNull(rald);
		Assert.assertTrue(rald.getId() > 0);
		
		String locName = Document.findLocationByDocId(doc.getId());
		Assert.assertNotNull(locName);
		Assert.assertEquals(locName, loc.getName());
	}

	@Test
	public void testSeven() throws Exception {
		ResearchStudy.findById(1);

		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest req = reqList.get(0);
		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
	
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);

		DocumentTemplate dt = dtList.get(0);
		Assert.assertNotNull(dt);

		Person pers = Person.findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);
		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);
		
		Group grp = pers.getGroups().iterator().next();
		Assert.assertNotNull(grp);
		Assert.assertTrue(grp.getId() > 0);
		
		Location loc = pers.getLocation();
		Assert.assertNotNull(loc);
		Assert.assertTrue(loc.getId() > 0);
		
		Document doc = Document.create(req, dt, "DNS");
		Assert.assertNotNull(doc);
		Assert.assertTrue(doc.getId() > 0);
		Assert.assertEquals(doc.getVersionNumber(), 1);

		Participant part = Participant.create(pers, req, loc, true, true, true);
		Assert.assertNotNull(part);
		Assert.assertTrue(part.getId() > 0);
		
		// now the request needs an admin participant document
		RequestParticipantDocument rapd = RequestParticipantDocument.create(req, part, doc); 
		Assert.assertNotNull(rapd);
		Assert.assertTrue(rapd.getId() > 0);
		
		String locName = Document.findLocationByDocId(doc.getId());
		Assert.assertNotNull(locName);
		Assert.assertEquals(locName, loc.getName());
	}

	@Test
	public void testEight() throws Exception {
		ResearchStudy.findById(1);

		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest req = reqList.get(0);
		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
	
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);

		DocumentTemplate dt = dtList.get(0);
		Assert.assertNotNull(dt);

		Person pers = Person.findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);
		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);
		
		Group grp = pers.getGroups().iterator().next();
		Assert.assertNotNull(grp);
		Assert.assertTrue(grp.getId() > 0);
		
		Location loc = pers.getLocation();
		Assert.assertNotNull(loc);
		Assert.assertTrue(loc.getId() > 0);
		
		Document doc = Document.create(req, dt, "DNS");
		Assert.assertNotNull(doc);
		Assert.assertTrue(doc.getId() > 0);
		Assert.assertEquals(doc.getVersionNumber(), 1);

		Participant part = Participant.create(pers, req, loc, true, true, true);
		Assert.assertNotNull(part);
		Assert.assertTrue(part.getId() > 0);
		
		// now the request needs an admin participant document
		RequestAdminParticipantDocument rapd = RequestAdminParticipantDocument.create(req, part, doc, grp); 
		Assert.assertNotNull(rapd);
		Assert.assertTrue(rapd.getId() > 0);
		
		String partName = Document.findParticipantNameByDocId(doc.getId());
		Assert.assertNotNull(partName);
		Assert.assertEquals(partName, pers.getFullName());
	}

	@Test
	public void testNine() throws Exception {
		ResearchStudy.findById(1);

		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest req = reqList.get(0);
		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
	
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);

		DocumentTemplate dt = dtList.get(0);
		Assert.assertNotNull(dt);

		Person pers = Person.findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);
		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);
		
		Group grp = pers.getGroups().iterator().next();
		Assert.assertNotNull(grp);
		Assert.assertTrue(grp.getId() > 0);
		
		Location loc = pers.getLocation();
		Assert.assertNotNull(loc);
		Assert.assertTrue(loc.getId() > 0);
		
		Document doc = Document.create(req, dt, "DNS");
		Assert.assertNotNull(doc);
		Assert.assertTrue(doc.getId() > 0);
		Assert.assertEquals(doc.getVersionNumber(), 1);

		Participant part = Participant.create(pers, req, loc, true, true, true);
		Assert.assertNotNull(part);
		Assert.assertTrue(part.getId() > 0);
		
		// now the request needs an admin participant document
		RequestParticipantDocument rapd = RequestParticipantDocument.create(req, part, doc); 
		Assert.assertNotNull(rapd);
		Assert.assertTrue(rapd.getId() > 0);
		
		String partName = Document.findParticipantNameByDocId(doc.getId());
		Assert.assertNotNull(partName);
		Assert.assertEquals(partName, pers.getFullName());
	}
}
